module Logic where

-- ----------------------------------------------------------------------
-- * True and False

data True : Set where
  <> : True

data False : Set where
  -- no constructors

ex-falsum : ∀ {A : Set} -> False -> A
ex-falsum {A} ()

-- ----------------------------------------------------------------------
-- * Exists and conjunction

data Exists : (A : Set) -> (A -> Set) -> Set where
  _,_ : {A : Set} -> {P : A -> Set} -> (a : A) -> P a -> Exists A P

infixl 2 _,_

∃ : {A : Set} -> (A -> Set) -> Set
∃ {A} P = Exists A P

infixl 4 _∧_ _×_

_∧_ : (A : Set) -> (B : Set) -> Set
A ∧ B = Exists A (λ x -> B)

_×_ : (A : Set) -> (B : Set) -> Set
A × B = A ∧ B

fst : ∀ {A : Set} {P : A -> Set} -> Exists A P -> A
fst (x , y) = x

snd : ∀ {A : Set} {P : A -> Set} -> (pair : Exists A P) -> P (fst pair)
snd (x , y) = y

-- ----------------------------------------------------------------------
-- * Disjunction: "or"

infixl 3 _∨_
data _∨_ : Set -> Set -> Set where
  left : ∀ {A B : Set} -> A -> A ∨ B
  right : ∀ {A B : Set} -> B -> A ∨ B

orElim : {A B C : Set} -> (A -> C) -> (B -> C) -> A ∨ B -> C
orElim f g (left x) = f x
orElim f g (right x) = g x

-- ----------------------------------------------------------------------
-- * Negation

¬ : Set -> Set
¬ A = A -> False

double-negation : {A : Set} -> A -> ¬ (¬ A)
double-negation a = λ x → x a

-- ----------------------------------------------------------------------
-- * If and only if

infix 1 _<->_ 
_<->_ : Set -> Set -> Set
A <-> B = (A -> B) ∧ (B -> A) 

lemma-iff-converse : ∀ {P Q} -> (P <-> Q) -> (Q <-> P)
lemma-iff-converse (left-to-right , right-to-left) = (right-to-left , left-to-right)
